#!/usr/bin/env python3
import argparse, os, json, subprocess, sys
from datetime import datetime, timezone

def utc_ts():
    return datetime.now(timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")

def main():
    ap = argparse.ArgumentParser(description="Run H21 and write a timestamped run under ./runs/")
    ap.add_argument("--manifest", default="config/manifest_h21.json")
    ap.add_argument("--outdir", default=None, help="Override output dir (default: runs/<UTC_timestamp>/)")
    ap.add_argument("--engine", default="engine_h21_atomic_rims.py")
    args = ap.parse_args()

    outdir = args.outdir or os.path.join("runs", utc_ts())
    os.makedirs(outdir, exist_ok=True)

    cmd = [sys.executable, args.engine, "--manifest", args.manifest, "--outdir", outdir]
    print("Running:", " ".join(cmd))
    res = subprocess.run(cmd, text=True, capture_output=True)
    print(res.stdout.strip())
    if res.stderr:
        print(res.stderr, file=sys.stderr)
    print("Outputs written to:", outdir)

if __name__ == "__main__":
    main()
